<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Core\Configure;
use Cake\Http\Exception\ForbiddenException;
use Cake\Http\Exception\NotFoundException;
use Cake\Http\Response;
use Cake\View\Exception\MissingTemplateException;
use Cake\ORM\TableRegistry;

/**
 * Static content controller
 *
 * This controller will render views from templates/Pages/
 *
 * @link https://book.cakephp.org/4/en/controllers/pages-controller.html
 */
class PagesController extends AppController
{
    /**
     * Displays a view
     *
     * @param string ...$path Path segments.
     * @return \Cake\Http\Response|null
     * @throws \Cake\Http\Exception\ForbiddenException When a directory traversal attempt.
     * @throws \Cake\View\Exception\MissingTemplateException When the view file could not
     *   be found and in debug mode.
     * @throws \Cake\Http\Exception\NotFoundException When the view file could not
     *   be found and not in debug mode.
     * @throws \Cake\View\Exception\MissingTemplateException In debug mode.
     */
	public function initialize(): void
	{
		parent::initialize();

		// $this->loadModel('Clients');
	}

    public function index(string ...$path): ?Response
    {
        if (!$path) {
            return $this->redirect('/');
        }
        if (in_array('..', $path, true) || in_array('.', $path, true)) {
            throw new ForbiddenException();
        }
        $page = $subpage = null;

        if (!empty($path[0])) {
            $page = $path[0];
        }
        if (!empty($path[1])) {
            $subpage = $path[1];
        }
        $this->set(compact('page', 'subpage'));

        try {
            return $this->render(implode('/', $path));
        } catch (MissingTemplateException $exception) {
            if (Configure::read('debug')) {
                throw $exception;
            }
            throw new NotFoundException();
        }
    }

    public function view($slug=''){
		
        $user = $this->request->getSession()->read('user');
        if(empty($user)){
            $this->redirect('/users/login/');
        }



		// $conditions = [];
		// if (!empty($this->getRequest()->getQuery('salesperson'))) {
			
		// 	$client_ids = $this->ClientsUsers
		// 		->find('list',['keyField'=>'client_id','valueField'=>'client_id'])
		// 		->where(['ClientsUsers.user_id'=>$this->request->query('salesperson')])
		// 		->toArray()
		// 	;
		// 	$client_ids = array_values($client_ids);
		// 	if(!empty($client_ids)){
		// 		$conditions['Clients.id IN'] = $client_ids;
		// 	}
		// }

		
		// $this->paginate['Clients'] = [
		// 	'conditions' => $conditions,
		// 	'order' => ['Clients.archived' => 'ASC', 'Clients.name'=>'ASC'],
		// 	'limit' => 100,
		// 	'maxLimit' => 1000,
		// 	'contain' => [
		// 		'Users',
		// 		'HighriseCompanies'
		// 	],
		// 	'matching' => ['Users']
		// ];
		
		// $clients = $this->paginate($this->Clients);
		// $this->set('clients', $clients);

		// echo json_encode($clients);

		// exit();


	}
    public function page_not_found(){
		$this->request->header($this->request->env('SERVER_PROTOCOL')." 404 Not Found", true);
		$page_id = $this->_findPageId('/page-not-found/');
		$this->page($page_id);
	}
	
	function _potential_issues(){
		$potential_issues = [];
		
		//invalid urls
		// $creative_ids = $this->AdReports->Dimensions
		// 	->find('list',['keyField'=>'creative_id','valueField'=>'creative_id'])
		// 	->where(['Dimensions.created >=' => date('Y-m-d H:i:s',strtotime('-2 weeks'))])
		// 	->group(['Dimensions.creative_id'])
		// 	->toArray()
		// ;
		// $creative_ids = array_values($creative_ids);
		// if(!empty($creative_ids)){
		// 	$creatives = $this->AdCreatives->find()
		// 		->where([
		// 			'AdCreatives.id IN'=>$creative_ids,
		// 			['AdCreatives.destination_url NOT LIKE' => 'http://%'],
		// 			['AdCreatives.destination_url NOT LIKE' => 'https://%'],
		// 		])
		// 		->contain(['Clients'])
		// 	;
		// 	if(!$creatives->isEmpty()){
		// 		foreach($creatives as $creative){
		// 			if(strpos($creative->name, 'Slimcut') !== false){
		// 				continue;
		// 			}
		// 			$info = $creative->destination_url;
		// 			$info = str_replace(' ', '<span style="color:red;">[space]</span>', $info);
		// 			$info = '<pre>'.$info.'</pre>';
		// 			
		// 			$potential_issues[] = [
		// 				'title' => '<strong>'.$creative->name.'</strong> Creative for <strong>'.$creative->client->name.'</strong> may have an invalid url.',
		// 				'info' => $info,
		// 				'link' => 'https://admanager.google.com/15020739#delivery/CreativeDetail/creativeId='.$creative->ad_manager_creative_id
		// 			];
		// 		}
		// 	}
		// }
		
		
		
		
		//inactive line items
		$now = date('Y-m-d H:i:s');
		$line_items = $this->AdLineItems->find()
			->where([
				[
					'NOT' => [
						'AdLineItems.status IN' => ['completed','delivering','paused']
					]
				],
				'AdLineItems.archived' => 0,
				'AdLineItems.start <' => $now,
				[
					'OR' => [
						'AdLineItems.end >' => $now,
						'AdLineItems.end IS NULL'
					]
				]
			])
			->contain(['AdOrders','AdOrders.Clients'])
		;
		
		if(!$line_items->isEmpty()){
			foreach($line_items as $line_item){
				if(in_array($line_item->order->client->name, [ 'Prebid', 'IntowowNonBillable', 'Amazon' ])){
					continue;
				}
				
				$potential_issues[] = [
					'title' => 'Line item for <strong>'.$line_item->order->client->name.'</strong> is set to <strong>'.$line_item->status.'</strong>.',
					'info' => $line_item->name,
					'link' => 'https://admanager.google.com/15020739#delivery/LineItemDetail/lineItemId='.$line_item->ad_manager_line_item_id
				];
			}
		}
		
		
		return $potential_issues;
	}
	
}
